#ifndef USERAPI_H_
#define USERAPI_H_

#include <stdio.h>


typedef struct {
	unsigned char mx;
	unsigned char my;
	unsigned char x1;
	unsigned char y1;
	unsigned char x2;
	unsigned char y2;
	unsigned char regionSize;
	unsigned char confidence;
	unsigned char pan;
	unsigned char tilt;
	unsigned char length;
	unsigned char sequence;
} TPacket;

typedef rom struct {
	unsigned char redMin, redMax, greenMin, greenMax, blueMin, blueMax;
	unsigned char yCrCb;
	unsigned char noiseFilter;
	unsigned char aecEnable;
	unsigned char aecLevel;
	unsigned char agcEnable;
	unsigned char agcLevel;
	unsigned char saturation;
	unsigned char blueGain;
	unsigned char redGain;
	unsigned char brightness;
	unsigned char panRangeFar;
	unsigned char panRangeNear;
	unsigned char panStep;
	unsigned char tiltRangeFar;
	unsigned char tiltRangeNear;
	unsigned char tiltStep;
} CameraInitializationData;

void IO_Initialization(void);
void SetDigitalOutput(unsigned char port, unsigned char value);
unsigned char GetDigitalInput(unsigned char port);
void SetDirection(unsigned char port, unsigned char direction);
void DefineControllerIO(unsigned char p1, unsigned char p2, unsigned char p3, unsigned char p4,
						unsigned char p5, unsigned char p6, unsigned char p7, unsigned char p8,
						unsigned char p9, unsigned char p10, unsigned char p11, unsigned char p12,
						unsigned char p13, unsigned char p14, unsigned char p15, unsigned char p16,
						unsigned char p17, unsigned char p18);
unsigned int GetAnalogInput(unsigned char port);

void SetPWM(unsigned char port, unsigned char speed);

#ifdef _VEX_BOARD
unsigned char GetPWM(unsigned char port);
#endif

void PrintToScreen(rom const char *fmt, ...);

unsigned char IsAutonomous(void);
unsigned char IsEnabled(void);
void SetCompetitionMode(unsigned char mode);

void StartEncoder(unsigned char channel);
void StopEncoder(unsigned char channel);
long GetEncoder(unsigned char channel);
void PresetEncoder(unsigned char channel, long presetValue);

void StartQuadEncoder(unsigned char channelA, unsigned char channelB, unsigned char invert);
void StopQuadEncoder(unsigned char channelA, unsigned char channelB);
long GetQuadEncoder(unsigned char channelA, unsigned char channelB);
void PresetQuadEncoder(unsigned char channelA, unsigned char channelB, long presetValue);

void StartGTSensor(unsigned char port, unsigned char invert);
void StopGTSensor(unsigned char port);
long GetGTSensor(unsigned char port);
void PresetGTSensor(unsigned char port, long presetValue);

void StartFastGTSensor(unsigned char port/*, unsigned char invert*/);
//void StopGTSensor(unsigned char port);
long GetFastGTSensor(unsigned char port);
//void PresetGTSensor(unsigned char port, long presetValue);

void StartInterruptWatcher(unsigned char port, unsigned char direction);
void StopInterruptWatcher(unsigned char port);
unsigned char GetInterruptWatcher(unsigned char port);

unsigned GetUltrasonic(unsigned char echo, unsigned char ping);
void StartUltrasonic(unsigned char echo, unsigned char ping);
void StopUltrasonic(unsigned char echo, unsigned char ping);

void InitGyro(unsigned char port);
void StartGyro(unsigned char port);
void StopGyro(unsigned char port);
int GetGyroAngle(unsigned char port);

void InitAccelerometer(unsigned char port);
void StartAccelerometer(unsigned char port);
int GetAcceleration(unsigned char port);
int GetVelocity(unsigned char port);
int GetDistance(unsigned char port);
void StopAccelerometer(unsigned char port);

void Wait(unsigned long ms);
void StartTimer(unsigned char timerNumber);
void StopTimer(unsigned char timerNumber);
void PresetTimer(unsigned char timerNumber, unsigned long value);
unsigned long GetTimer(unsigned char timerNumber);

unsigned char GetOIDInput(unsigned char port, unsigned char channel);
unsigned char GetOIAInput(unsigned char port, unsigned char channel);
void OIToDOutput(unsigned char port, unsigned char function, unsigned char dport);
void OIToPWM(unsigned char port, unsigned char function, unsigned char pwm, unsigned char invert);

#ifdef _FRC_BOARD
void SetOILED(unsigned char led, unsigned char value);
void SetUserDisplay(unsigned char value);
void SetRelay(unsigned char port, char forward, char reverse);
void OIToRelay(unsigned char port, unsigned char function,
				unsigned char relayNumber, unsigned char direction);
#endif // _FRC_BOARD

void Arcade2(unsigned char movePort, unsigned char moveChannel,
				unsigned char rotatePort, unsigned char rotateChannel,
				unsigned char leftPWM, unsigned char rightPWM,
				unsigned char leftInvert, unsigned char rightInvert);
void Arcade4(unsigned char ucMovePort, unsigned char ucMoveChannel,
			unsigned char ucRotatePort, unsigned char ucRotateChannel,
			unsigned char ucLeftfrontPWM, unsigned char ucRightfrontPWM,
			unsigned char ucLeftrearPWM, unsigned char ucRightrearPWM,
			unsigned char ucLeftfrontInvert, unsigned char ucRightfrontInvert,
			unsigned char ucLeftrearInvert, unsigned char ucRightrearInvert);
void Tank2(unsigned char leftPort, unsigned char leftChannel,
			unsigned char rightPort, unsigned char rightChannel,
			unsigned char leftPWM, unsigned char rightPWM, 
			unsigned char leftInvert, unsigned char rightInvert);
void Tank4(unsigned char ucLeftPort, unsigned char ucLeftChannel,
			unsigned char ucRightPort, unsigned char ucRightChannel,
			unsigned char ucLeftfrontPWM, unsigned char ucRightfrontPWM,
			unsigned char ucLeftrearPWM, unsigned char ucRightrearPWM,
			unsigned char ucLeftfrontInvert, unsigned char ucRightfrontInvert,
			unsigned char ucLeftrearInvert, unsigned char ucRightrearInvert);

void InitCamera(unsigned char cameraInitIndex);
void CaptureTrackingData(
			unsigned char *centerX,
			unsigned char *centerY,
			unsigned char *x1,
			unsigned char *y1,
			unsigned char *x2,
			unsigned char *y2,
			unsigned char *regionSize,
			unsigned char *confidence,
			unsigned char *pan,
			unsigned char *tilt);
void StopCamera(void);
void StartCamera(void);
TPacket *CopyTrackingData(void);
void SetServoTracking(unsigned char panTracking, unsigned char tiltTracking);
void SetServoPosition(unsigned char servo, unsigned char position);

unsigned GetSecondClock(void);
unsigned long GetMsClock(void);
unsigned GetGameTime(void);

#ifdef _FRC_BOARD
void InitPressureSwitch(unsigned char pressureSwitchPort, unsigned char relayPort);
#endif //_FRC_BOARD

#endif /*USERAPI_H_*/
