#ifndef BUILTIN_H_
#define BUILTIN_H_

/*
 * BuiltIns.h
 * Definitions for everything that is in WPILib that is not included in EasyC. The
 * EasyC stuff is in UserAPI.h
 */

#include "UserAPI.h"

#ifdef _FRC_BOARD

#define PWM1_GREEN 0
#define PWM1_RED 1
#define PWM2_GREEN 2
#define PWM2_RED 3
#define RELAY1_GREEN 4
#define RELAY1_RED 5
#define RELAY2_GREEN 6
#define RELAY2_RED 7
#define SWITCH1_LED 8
#define SWITCH2_LED 9
#define SWITCH3_LED 10

#define PORT_1 1
#define PORT_2 2
#define PORT_3 3
#define PORT_4 4
#define X_AXIS 1
#define Y_AXIS 2
#define WHEEL_AXIS 3
#define AUX_AXIS 4
#define TRIGGER_SW 1
#define TOP_SW 2
#define AUX1_SW 3
#define AUX2_SW 4
#define ALT_TRIGGER 5
#define ALT_THUMB 6
#define ALT_AUX1_SW 7
#define ALT_AUX2_SW 8

#endif // _FRC_BOARD

#ifdef _VEX_BOARD

#define PORT_1 1
#define PORT_2 2
#define CHANNEL_1 1
#define CHANNEL_2 2
#define CHANNEL_3 3
#define CHANNEL_4 4
#define CHANNEL_5 5
#define CHANNEL_6 6
#define CHANNEL_5_TOP 1
#define CHANNEL_5_BOTTOM 2
#define CHANNEL_6_TOP 3
#define CHANNEL_6_BOTTOM 4

#endif // _VEX_BOARD

#define INPUT   1
#define OUTPUT  0

// which edge will cause the ISR to be  called (int 1 & 2 done in hardware, 3-6 in software)
#define RISING_EDGE 1
#define FALLING_EDGE 0
#define DISABLE_INTERRUPTS INTCONbits.GIEL = 0
#define ENABLE_INTERRUPTS INTCONbits.GIEL = 1

void RegisterInterruptHandler(unsigned char port, unsigned char edge, void (*handler)(unsigned char port, unsigned char value));
void UnRegisterInterruptHandler(unsigned char port);
void SetInterruptEdge(unsigned char port, unsigned char edge);

unsigned char ReadSerialPortOne(void);
void WriteSerialPortOne(unsigned char);
unsigned char ReadSerialPortTwo(void);
void WriteSerialPortTwo(unsigned char);

void InitializeCompass(unsigned char port);
unsigned GetCompassHeading(void);

void SetMotor(unsigned char port, int speed);
void SetInvertedMotor(unsigned char port);
void Motor(unsigned char pwmPort, int speed);
void Motors(int leftSpeed, int rightSpeed);
void Drive(int speed, int direction);
void TwoWheelDrive(unsigned char _leftMotor, unsigned char _rightMotor);
void FourWheelDrive(unsigned char _leftMotor, unsigned char _frontLeftMotor,
					unsigned char _rightMotor, unsigned char _frontRightMotor);
					
unsigned int Get_Analog_Value (unsigned char ADC_channel);

typedef void (*TimerHandler)(void);
unsigned GetSecondClock(void);		// gets the 1-sec clock value
unsigned long GetUsClock(void);	// time in microseconds
unsigned long GetMsClock(void);	// get the ms clock
unsigned GetGameTime(void);		// time since the robot was enabled

void RegisterSingleTimer(unsigned long time, void (*handler)(void));
void RegisterRepeatingTimer(unsigned long time, void (*handler)(void));
void CancelTimer(void (*handler)(void));

unsigned char GetPacketNumber(void);

unsigned GetMainBattery(void);
unsigned GetBackupBattery(void);

void InitializeCamera(CameraInitializationData *c);
unsigned char GetCameraStatus(void);

#endif /*BUILTIN_H_*/
