/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.team190.mccerrorparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.errorparsers.AbstractErrorParser;
import org.eclipse.cdt.internal.errorparsers.ErrorPattern;

public class MCCErrorParser
extends AbstractErrorParser {
    private static final Pattern[] varPatterns = new Pattern[]{Pattern.compile("'(.*)' undeclared"), Pattern.compile("'(.*)' defined but not used"), Pattern.compile("conflicting types for '(.*)'"), Pattern.compile("parse error before '(.*)'")};
    private static final ErrorPattern[] patterns = new ErrorPattern[]{new ErrorPattern("\\(Each undeclared identifier is reported only once"), new ErrorPattern("for each function it appears in.\\)"), new ErrorPattern(": note:"), new ErrorPattern("instantiated from here"), new ErrorPattern("(.*?):([0-9]+):([0-9]+:)? ?((.*?[Ww]arning)?.*)", 1, 2, 4, 0, 0){

        public String getVarName(Matcher matcher) {
            String desc = this.getDesc(matcher);
            Matcher varMatcher = null;
            int i = 0;
            while (i < varPatterns.length) {
                varMatcher = varPatterns[i].matcher(desc);
                if (varMatcher.find()) break;
                varMatcher = null;
                ++i;
            }
            return varMatcher != null ? varMatcher.group(1) : null;
        }

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(5);
            if (warningGroup != null) {
                return 1;
            }
            return 2;
        }
    }};

    public MCCErrorParser() {
        super(patterns);
    }
}

